<?php
session_start();
error_reporting(0);
include('includes/config.php');

if(strlen($_SESSION['adminlogin'])==0) {    
    header('location:index.php');
} else {
    // Fetch current Nagad price and control status from the database
    $sql = "SELECT cc_nagadinfo_price, cc_nagadinfo_control FROM control WHERE id = 1";
    $query = $dbh->prepare($sql);
    $query->execute();
    $result = $query->fetch(PDO::FETCH_ASSOC);
    $current_price = $result['cc_nagadinfo_price'];
    $control_status = $result['cc_nagadinfo_control'];

    // Handle the update of Nagad price
    if(isset($_POST['update_price'])) {
        $price = $_POST['cc_nagadinfo_price'];
        // Update the Nagad price in the database
        $sql = "UPDATE control SET cc_nagadinfo_price = :price WHERE id = 1";
        $query = $dbh->prepare($sql);
        $query->bindParam(':price', $price, PDO::PARAM_STR);
        $query->execute();
        $msg = "Price updated successfully!";
       echo '<script type="text/javascript">
                setTimeout(function() {
                    window.location.href = "nagad-control.php";
                }, 1000); 
              </script>';
    }

    // Handle turning Nagad control ON
    if(isset($_POST['turn_on'])) {
        $sql = "UPDATE control SET cc_nagadinfo_control = 1 WHERE id = 1";
        $query = $dbh->prepare($sql);
        $query->execute();
        $msg = "Nagad control is now ON!";
       echo '<script type="text/javascript">
                setTimeout(function() {
                    window.location.href = "nagad-control.php";
                }, 1000); 
              </script>';
    }

    // Handle turning Nagad control OFF
    if(isset($_POST['turn_off'])) {
        $sql = "UPDATE control SET cc_nagadinfo_control = 0 WHERE id = 1";
        $query = $dbh->prepare($sql);
        $query->execute();
        $msg = "Nagad control is now OFF!";
    echo '<script type="text/javascript">
                setTimeout(function() {
                    window.location.href = "nagad-control.php";
                }, 1000); 
              </script>';
    }
?>
<!doctype html>
<html lang="en" class="no-js">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1">
    <title>Nagad Information Control </title>
    <link rel="stylesheet" href="css/font-awesome.min.css">
    <link rel="stylesheet" href="css/bootstrap.min.css">
    <link rel="stylesheet" href="css/style.css">
    <style>
        .errorWrap { padding: 10px; background: #dd3d36; color: #fff; }
        .succWrap { padding: 10px; background: #5cb85c; color: #fff; }
    </style>
</head>

<body>
    <?php include('includes/header.php');?>
    <div class="ts-main-content">
        <?php include('includes/leftbar.php');?>
        <div class="content-wrapper">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12">
                        <h3 class="page-title">Nagad Information Control </h3>
                        <div class="panel panel-default">
                            <div class="panel-heading">Control Settings</div>
                            <div class="panel-body">
                                <?php if($msg) { ?>
                                    <div class="succWrap"><?php echo htmlentities($msg); ?></div>
                                <?php } ?>
                                <form method="post" class="form-horizontal">
                                    <!-- Nagad Price Section -->
                                    <div class="form-group">
                                        <label class="col-sm-2 control-label">Nagad Price</label>
                                        <div class="col-sm-4">
                                            <input type="number" name="cc_nagadinfo_price" class="form-control" placeholder=" <?php echo $current_price; ?>" value="" min="0" max="10000">
                                        </div>
                                        <div class="col-sm-4">
                        <br>
                                            <button class="btn btn-primary" name="update_price" type="submit">Update Nagad Price</button>
                                        </div>
                                    </div>

                                    <!-- Nagad Control Section -->
                                    <div class="form-group">
                                        <label class="col-sm-2 control-label">Nagad Control</label>
                                        <div class="col-sm-4">
                                            <?php if($control_status == 0) { ?>
                                                <button class="btn btn-success" name="turn_on" type="submit">Turn ON</button>
                                            <?php } else { ?>
                                                <button class="btn btn-danger" name="turn_off" type="submit">Turn OFF</button>
                                            <?php } ?>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>  
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="js/jquery.min.js"></script>
    <script src="js/main.js"></script>
    <script src="js/bootstrap.min.js"></script>
</body>
</html>
<?php } ?>
