<?php
session_start();
error_reporting(0);
include('includes/config.php');
if(strlen($_SESSION['adminlogin'])==0) {	
	header('location:index.php');
} else {
	if(isset($_POST['submit'])) {	
		$name = $_POST['name'];
		$email = $_POST['email'];
		$bot_token = $_POST['bot_token'];
		$admin_chat_id = $_POST['admin_chat_id'];

		// Update admin details
		$sql = "UPDATE admin SET username = :name, email = :email";
		$query = $dbh->prepare($sql);
		$query->bindParam(':name', $name, PDO::PARAM_STR);
		$query->bindParam(':email', $email, PDO::PARAM_STR);
		$query->execute();

		// Update Telegram settings
		$sql2 = "UPDATE telegram_settings SET bot_token = :bot_token, admin_chat_id = :admin_chat_id";
		$query2 = $dbh->prepare($sql2);
		$query2->bindParam(':bot_token', $bot_token, PDO::PARAM_STR);
		$query2->bindParam(':admin_chat_id', $admin_chat_id, PDO::PARAM_STR);
		$query2->execute();

		$msg = "Information Updated Successfully";
	}

	// Fetch current admin and telegram settings
	$sql = "SELECT * from admin";
	$query = $dbh->prepare($sql);
	$query->execute();
	$result = $query->fetch(PDO::FETCH_OBJ);

	$sql2 = "SELECT * FROM telegram_settings";
	$query2 = $dbh->prepare($sql2);
	$query2->execute();
	$telegram_settings = $query2->fetch(PDO::FETCH_OBJ);
?>

<!doctype html>
<html lang="en" class="no-js">
<head>
	<meta charset="UTF-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1">
	<title>Edit Admin</title>
	<link rel="stylesheet" href="css/font-awesome.min.css">
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<link rel="stylesheet" href="css/style.css">
	<style>
		.errorWrap { padding: 10px; background: #dd3d36; color: #fff; }
		.succWrap { padding: 10px; background: #5cb85c; color: #fff; }
	</style>
</head>

<body>
<?php include('includes/header.php');?>
<div class="ts-main-content">
<?php include('includes/leftbar.php');?>
	<div class="content-wrapper">
		<div class="container-fluid">
			<div class="row">
				<div class="col-md-12">
					<h3 class="page-title">Manage Admin</h3>
					<div class="panel panel-default">
						<div class="panel-heading">Edit Info</div>
						<?php if($error){?><div class="errorWrap"><?php echo htmlentities($error); ?></div><?php } 
							else if($msg){?><div class="succWrap"><?php echo htmlentities($msg); ?></div><?php } ?>
						<div class="panel-body">
							<form method="post" class="form-horizontal" enctype="multipart/form-data">
								<div class="form-group">
									<label class="col-sm-2 control-label">Username</label>
									<div class="col-sm-4">
										<input type="text" name="name" class="form-control" required value="<?php echo htmlentities($result->username);?>">
									</div>
									<label class="col-sm-2 control-label">Email</label>
									<div class="col-sm-4">
										<input type="email" name="email" class="form-control" required value="<?php echo htmlentities($result->email);?>">
									</div>
								</div>
								<div class="form-group">
									<label class="col-sm-2 control-label">Bot Token</label>
									<div class="col-sm-4">
										<input type="text" name="bot_token" class="form-control" required value="<?php echo htmlentities($telegram_settings->bot_token);?>">
									</div>
									<label class="col-sm-2 control-label">Admin Chat ID</label>
									<div class="col-sm-4">
										<input type="text" name="admin_chat_id" class="form-control" required value="<?php echo htmlentities($telegram_settings->admin_chat_id);?>">
									</div>
								</div>
								<div class="form-group">
									<div class="col-sm-8 col-sm-offset-2">
										<button class="btn btn-primary" name="submit" type="submit">Save Changes</button>
									</div>
								</div>
							</form>
						</div>
					</div>	
				</div>
			</div>
		</div>
	</div>
</div>

<script src="js/jquery.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="js/main.js"></script>
<script>
	$(document).ready(function () {          
		setTimeout(function() {
			$('.succWrap').slideUp("slow");
		}, 3000);
	});
</script>
</body>
</html>
<?php } ?>
