<?php
session_start();
error_reporting(1);
include('includes/config.php');
include('includes/db.php');

//mail option
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
require '../vendor/autoload.php';
$mail = new PHPMailer(true); 

if (strlen($_SESSION['adminlogin']) == 0) {
    header('location:index.php');
    die();
} 


if(!isset($_GET['id']) || empty($_GET['id']) || !is_numeric($_GET['id'])){
    header('location: signDash.php?noid');
    die();
}

$id = $_GET['id'];
//get order info
$orderInfoSql = "SELECT * FROM sign where id = (:id) LIMIT 1";
$orderInfoQuery = $dbh->prepare($orderInfoSql);
$orderInfoQuery->bindParam(':id',$id,PDO::PARAM_STR);
$orderInfoQuery->execute();


if($orderInfoQuery->rowCount() <= 0){
    header('location: signDash.php?OrderNotFound');
    die();
}
//get order info
$orderInfoDetail = $orderInfoQuery->fetchAll(PDO::FETCH_OBJ);

if($orderInfoDetail[0]->status != 1){
    header('location: signDash.php?noEditable');
    die();
}

//upload and edit


if(isset($_POST['submit']) && $_FILES['sign']){

    if($_FILES['sign']['type'] != 'application/pdf'){
        echo "<script>alert('Invalid File')</script>";
    }else{
        $url = pathinfo($_FILES['sign']['name'],PATHINFO_FILENAME).".pdf";
        move_uploaded_file($_FILES['sign']['tmp_name'],"sainCopy/".$url);

        //store file path in db
        // change status for deleted
        $sqlForUpdate = "UPDATE `sign` SET `status` = '2', `url` = (:url),`delivery_time` = (:delivery_time) WHERE `sign`.`id` = (:id)";
        $queryForUpdate = $dbh->prepare($sqlForUpdate);
        $queryForUpdate->bindParam(':url',$url,PDO::PARAM_STR);
        $queryForUpdate->bindParam(':id',$id,PDO::PARAM_INT);
        $queryForUpdate->bindParam(':delivery_time',date("Y-m-d h:i:s A"),PDO::PARAM_STR);
        $queryForUpdate->execute();


        //send mail
        try {
            //Server settings
            $mail->SMTPDebug = 0; // Enable verbose debug output
            $mail->CharSet = "UTF-8";
            $mail->isSMTP(); // Set mailer to use SMTP
            $mail->Host = $mailHost; // Specify main and backup SMTP servers
            $mail->SMTPAuth = true; // Enable SMTP authentication
            $mail->Username = $mailUsername; // SMTP username
            $mail->Password = $mailPassword; // SMTP password
            $mail->SMTPSecure = 'ssl'; // Enable TLS encryption, `ssl` also accepted
            $mail->Port = $mailPort; // TCP port to connect to
        
            //Recipients
            $mail->setFrom('no-reply@bdnid.org', 'NIDHUT');
            $mail->addAddress($orderInfoDetail[0]->user); // Add a recipient
            //$mail->addCC('cc@example.com');   //Uncomment to add CC recipient
            //$mail->addBCC('bcc@example.com'); //Uncomemnt to add BCC recipient
            
            
            //Content
            $mail->isHTML(true); // Set email format to HTML
            $mail->Subject = 'আপনার সাইন কপি ডেলিভারি করা হয়েছে।';
            $orderTime = date("Y-m-d h:i:s A");
            $mail->Body    = "
                <h1>সাইন কপি অর্ডার ডিটেইলসঃ </h1>
                <br>
                <p>নামঃ ".$orderInfoDetail[0]->name."</p>
                <p>জন্ম তারিখঃ ".$orderInfoDetail[0]->dob."</p>
                <p>আইডি নাম্বার/ফর্ম নাম্বার/জন্ম নিবন্ধনঃ".$orderInfoDetail[0]->nid_num." </p>
                <p>নোটঃ ".$orderInfoDetail[0]->note." </p>
                <p>ডেলিভারির সময়ঃ $orderTime </p>

                <h1 style=\"color:red\" >আপনার একাউন্টে লগ ইন করে ফাইল ডাউনলোড করুন।</h1>
            ";
            // $mail->AltBody = 'This is the body in plain text for non-HTML mail clients';
        
            $mail->send();
        } catch (Exception $e) {
            echo "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";
        }

        header('location: signDash.php?successDelevery');
        die();
    }
}

?>
    <!doctype html>
    <html lang="en" class="no-js">

    <head>
        <meta charset="UTF-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1">
        <meta name="description" content="">
        <meta name="author" content="">
        <meta name="theme-color" content="#3e454c">

        <title>Edit Order</title>

        <!-- Font awesome -->
        <link rel="stylesheet" href="css/font-awesome.min.css">
        <!-- Sandstone Bootstrap CSS -->
        <link rel="stylesheet" href="css/bootstrap.min.css">
        <!-- Admin Stye -->
        <link rel="stylesheet" href="css/style.css">

        <script type="text/javascript" src="../vendor/countries.js"></script>
        <style>
            .errorWrap {
                padding: 10px;
                margin: 0 0 20px 0;
                background: #dd3d36;
                color: #fff;
                -webkit-box-shadow: 0 1px 1px 0 rgba(0, 0, 0, .1);
                box-shadow: 0 1px 1px 0 rgba(0, 0, 0, .1);
            }

            .succWrap {
                padding: 10px;
                margin: 0 0 20px 0;
                background: #5cb85c;
                color: #fff;
                -webkit-box-shadow: 0 1px 1px 0 rgba(0, 0, 0, .1);
                box-shadow: 0 1px 1px 0 rgba(0, 0, 0, .1);
            }
        </style>
    </head>
    <body>
        <?php
        $sql = "SELECT * from users where email = '$editid'";
        $d = mysqli_query($link,$sql);
        $result = mysqli_fetch_assoc($d);
        ?>
        <?php include('includes/header.php'); ?>
        <div class="ts-main-content">
            <?php include('includes/leftbar.php'); ?>
            <div class="content-wrapper">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-md-12">
                            <h3 class="page-title">Edit Order : <?php echo htmlentities($result['name']); ?></h3>
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="panel panel-default">
                                        <div class="panel-heading">Order Info:<?php echo $orderInfoDetail[0]->user ?></div>
                                        <div class="panel-body">
                                            <form method="post" class="form-horizontal" enctype="multipart/form-data" action="signEdit.php?id=<?php echo $id ?>">
                                                <div class="form-group">
                                                    <label class="col-sm-2 control-label">ID</label>
                                                    <div class="col-sm-4">
                                                        <h4><?php echo htmlentities($orderInfoDetail[0]->id); ?></h4>
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <label class="col-sm-2 control-label">Type</label>
                                                    <div class="col-sm-4">
                                                        <h4><?php echo htmlentities($orderInfoDetail[0]->name); ?></h4>
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <label class="col-sm-2 control-label">DOB</label>
                                                    <div class="col-sm-4">
                                                        <h4><?php echo htmlentities($orderInfoDetail[0]->dob); ?></h4>
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <label class="col-sm-2 control-label">NID/Form/Voter No.</label>
                                                    <div class="col-sm-4">
                                                        <h4><?php echo htmlentities($orderInfoDetail[0]->nid_num); ?></h4>
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <label class="col-sm-2 control-label">Order Time</label>
                                                    <div class="col-sm-4">
                                                        <h4><?php echo htmlentities($orderInfoDetail[0]->order_time); ?></h4>
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <label class="col-sm-2 control-label">User</label>
                                                    <div class="col-sm-4">
                                                        <h4><?php echo htmlentities($orderInfoDetail[0]->user); ?></h4>
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <label class="col-sm-2 control-label">Note</label>
                                                    <div class="col-sm-4">
                                                        <h4><?php echo htmlentities($orderInfoDetail[0]->note); ?></h4>
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <label class="col-sm-2 control-label">Status</label>
                                                    <div class="col-sm-4">
                                                    <?php
															if($orderInfoDetail[0]->status == 1){
																echo "<p class='btn btn-warning'>Processing</p>";
															}
															?>
                                                    </div>
                                                </div>
                                                
                                                
                                                    <div class="form-group">
                                                        <label class="col-sm-2 control-label">Upload Sign<span style="color:red">*</span></label>
                                                        <div class="col-sm-4">
                                                            

                                                            <input type="file" class="form-control" name="sign">

                                                            
                                                        </div>
                                                    </div>

                                                    <div class="form-group">
                                                        <div class="col-sm-8 col-sm-offset-2">
                                                            <a href="signStatusUpdate.php?id=<?php echo $id ?>&status=3" class="btn btn-primary">Delivery as খুজে পাওয়া যায়নি।</a>
                                                            <a href="signStatusUpdate.php?id=<?php echo $id ?>&status=4" class="btn btn-warning">Delivery as Match Found</a>
                                                            <a href="signStatusUpdate.php?id=<?php echo $id ?>&status=5" class="btn btn-danger">Delivery as Dead</a>
                                                        </div>
                                                    </div>


                                                    <div class="form-group">
                                                        <div class="col-sm-8 col-sm-offset-2">
                                                            <button class="btn btn-primary" name="submit" type="submit">Upload Sign</button>
                                                        </div>
                                                    </div>
                                                

                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>



                        </div>
                    </div>



                </div>
            </div>
        </div>

        <!-- Loading Scripts -->
        <script src="js/jquery.min.js"></script>
        <script src="js/bootstrap.min.js"></script>
        <script src="js/main.js"></script>
        <script type="text/javascript">
            $(document).ready(function() {
                setTimeout(function() {
                    $('.succWrap').slideUp("slow");
                }, 3000);
            });
        </script>

    </body>

    </html>
