<?php
session_start();
error_reporting(0);
include('includes/config.php');

if (strlen($_SESSION['adminlogin']) == 0) {
    header('location:index.php');
    exit();
} else {
    $msg = '';
    $error = '';

    // Delete User
    if (isset($_GET['del']) && isset($_GET['name'])) {
        $id = $_GET['del'];
        $name = $_GET['name'];

        $sql = "DELETE FROM users WHERE id = :id";
        $query = $dbh->prepare($sql);
        $query->bindParam(':id', $id, PDO::PARAM_STR);
        $query->execute();

        $sql2 = "INSERT INTO deleteduser (email) VALUES (:name)";
        $query2 = $dbh->prepare($sql2);
        $query2->bindParam(':name', $name, PDO::PARAM_STR);
        $query2->execute();

        $msg = "Data Deleted successfully";
    }

    // Change User Status - Unconfirm
    if (isset($_REQUEST['unconfirm'])) {
        $aeid = intval($_GET['unconfirm']);
        $memstatus = 1;
        $sql = "UPDATE users SET status = :status WHERE id = :aeid";
        $query = $dbh->prepare($sql);
        $query->bindParam(':status', $memstatus, PDO::PARAM_STR);
        $query->bindParam(':aeid', $aeid, PDO::PARAM_STR);
        $query->execute();
        $msg = "Changes Successfully";
    }

    // Change User Status - Confirm
    if (isset($_REQUEST['confirm'])) {
        $aeid = intval($_GET['confirm']);
        $memstatus = 0;
        $sql = "UPDATE users SET status = :status WHERE id = :aeid";
        $query = $dbh->prepare($sql);
        $query->bindParam(':status', $memstatus, PDO::PARAM_STR);
        $query->bindParam(':aeid', $aeid, PDO::PARAM_STR);
        $query->execute();
        $msg = "Changes Successfully";
    }

    /// Delete All 0 Balance Users
    if (isset($_GET['delete_zero_balance'])) {
        try {
            // Find and save deleted users
            $sql = "SELECT id, email FROM users WHERE balance <= 0 OR balance IS NULL";
            $query = $dbh->prepare($sql);
            $query->execute();
            $zeroBalanceUsers = $query->fetchAll(PDO::FETCH_ASSOC);

            if (count($zeroBalanceUsers) > 0) {
                foreach ($zeroBalanceUsers as $user) {
                    // Save deleted user in deleteduser table
                    $insertSql = "INSERT INTO deleteduser (email) VALUES (:email)";
                    $insertQuery = $dbh->prepare($insertSql);
                    $insertQuery->bindParam(':email', $user['email'], PDO::PARAM_STR);
                    $insertQuery->execute();
                }

                // Delete all users with zero balance
                $deleteSql = "DELETE FROM users WHERE balance <= 0 OR balance IS NULL";
                $deleteQuery = $dbh->prepare($deleteSql);
                $deleteQuery->execute();

                $msg = count($zeroBalanceUsers) . " Zero Balance Accounts Deleted Successfully!";
            } else {
                $msg = "No Zero Balance Accounts Found!";
            }
        } catch (Exception $e) {
            $error = "Something went wrong: " . $e->getMessage();
        }
    }

    // Function to get total balance added
    function getTotalBalanceAdded($dbh)
    {
        $sql = "SELECT SUM(balance) AS total_balance FROM users WHERE status = 1";
        $query = $dbh->prepare($sql);
        $query->execute();
        $result = $query->fetch(PDO::FETCH_ASSOC);
        return $result['total_balance'];
    }

    // Get total balance added
    $totalBalanceAdded = getTotalBalanceAdded($dbh);
?>

<!DOCTYPE html>
<html lang="en" class="no-js">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1">
    <meta name="description" content="">
    <meta name="author" content="">
    <meta name="theme-color" content="#3e454c">

    <title>Manage Users</title>

    <!-- Font awesome -->
    <link rel="stylesheet" href="css/font-awesome.min.css">
    <!-- Sandstone Bootstrap CSS -->
    <link rel="stylesheet" href="css/bootstrap.min.css">
    <!-- DataTables CSS -->
    <link rel="stylesheet" href="//cdn.datatables.net/1.13.4/css/jquery.dataTables.min.css">
    <!-- Admin Style -->
    <link rel="stylesheet" href="css/style.css">
    <style>
body {
    font-family: 'Helvetica Neue', Arial, sans-serif;
    background-color: #F5F5F5;
    margin: 0;
    padding: 0;
    color: #333333;
}

.content-wrapper {
    padding: 20px;
    background-color: #fff;
    border-radius: 8px;
    box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
    animation: fadeIn 1s ease-in-out;
}

.page-title {
    margin-bottom: 20px;
    font-size: 24px;
    color: #4CAF50;
    animation: slideIn 1s ease-in-out;
}

.panel {
    border: 1px solid #ddd;
    border-radius: 8px;
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
    animation: fadeIn 1s ease-in-out;
}

.panel-heading {
    background-color: #FFEB3B;
    border-bottom: 1px solid #ddd;
    padding: 15px;
    border-top-left-radius: 8px;
    border-top-right-radius: 8px;
}

.panel-body {
    padding: 20px;
}

/* Table Styles */
.table {
    width: 100%;
    margin-bottom: 20px;
    border-collapse: collapse;
    border-spacing: 0;
    animation: fadeIn 1s ease-in-out;
}

.table th,
.table td {
    border: 1px solid #ddd;
    padding: 12px;
    text-align: left;
}

.table th {
    background-color: #4CAF50;
    color: #fff;
    font-weight: bold;
}

.table tr:nth-child(even) {
    background-color: #f9f9f9;
}

.table tr:hover {
    background-color: #f1f1f1;
}

/* Image Styles */
.table img {
    width: 50px;
    height: 50px;
    border-radius: 50%;
    object-fit: cover;
    animation: scaleUp 1s ease-in-out;
}

/* Button Styles */
.btn {
    display: inline-block;
    padding: 10px 15px;
    font-size: 14px;
    color: #fff;
    background-color: #4CAF50;
    border: none;
    border-radius: 4px;
    cursor: pointer;
    text-decoration: none;
    transition: background-color 0.3s ease;
}

.btn:hover {
    background-color: #45a049;
}

.btn-primary {
    background-color: #4CAF50;
}

.btn-primary:hover {
    background-color: #45a049;
}

/* Action Icons */
.fa-pencil,
.fa-trash,
.fa-check-circle,
.fa-times-circle {
    margin-right: 5px;
    animation: scaleUp 1s ease-in-out;
}

.fa-trash {
    color: red;
}

/* Search Form */
.panel-heading form {
    display: flex;
    align-items: center;
}

.panel-heading input[type="text"] {
    padding: 10px;
    border: 1px solid #ddd;
    border-radius: 4px;
    margin-right: 10px;
    flex: 1;
    animation: fadeIn 1s ease-in-out;
}

/* Message Styles */
.errorWrap,
.succWrap {
    padding: 10px;
    margin: 20px 0;
    border-radius: 4px;
    color: #fff;
    box-shadow: 0 1px 1px 0 rgba(0, 0, 0, 0.1);
    animation: fadeIn 1s ease-in-out;
}

.errorWrap {
    background-color: #dd3d36;
}

.succWrap {
    background-color: #5cb85c;
}

/* Total Balance Table */
.total-balance-table {
    margin-top: 20px;
    width: 100%;
    border-collapse: collapse;
    animation: fadeIn 1s ease-in-out;
}

.total-balance-table th,
.total-balance-table td {
    border: 1px solid #ddd;
    padding: 12px;
    text-align: left;
}

.total-balance-table th {
    background-color: #4CAF50;
    color: #fff;
    font-weight: bold;
}

/* Animations */
@keyframes fadeIn {
    from {
        opacity: 0;
    }
    to {
        opacity: 1;
    }
}

@keyframes slideIn {
    from {
        transform: translateX(-100%);
    }
    to {
        transform: translateX(0);
    }
}

@keyframes scaleUp {
    from {
        transform: scale(0.9);
    }
    to {
        transform: scale(1);
    }
}
    </style>
</head>

<body>
    <?php include('includes/header.php'); ?>

    <div class="ts-main-content">
        <?php include('includes/leftbar.php'); ?>
        <div class="content-wrapper">
            <div class="container-fluid">

                <div class="row">
                    <div class="col-md-12">

                        <h2 class="page-title">Manage Users</h2>

                        <div class="panel panel-default">
                            <div class="panel-heading">
                                <div class="row">
                                    <div class="col-md-6">List Users</div>
                                    <div class="col-md-6">
                                        <form method="GET">
                                            <input type="text" name="search" placeholder="Search by Email or Name">
                                            <button type="submit" class="btn btn-primary">Search</button>
                                        </form>
                                        <!-- Delete Zero Balance Accounts Button -->
                                        <a href="userlist.php?delete_zero_balance=true" onclick="return confirm('Are you sure you want to delete all zero balance accounts?');" class="btn btn-danger">
                                            Delete 0 Balance Accounts
                                        </a>
                                    </div>
                                </div>
                            </div>
                            <div class="panel-body">
                                <?php if ($error) { ?><div class="errorWrap" id="msgshow"><?php echo htmlentities($error); ?> </div><?php } else if ($msg) { ?><div class="succWrap" id="msgshow"><?php echo htmlentities($msg); ?> </div><?php } ?>
                                <table id="myTable" class="display table table-striped table-bordered table-hover" cellspacing="0" width="100%">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Image</th>
                                            <th>Name</th>
                                            <th>Email</th>
                                            <th>Gender</th>
                                            <th>Phone</th>
                                            <th>Balance</th>
                                            <th>Account</th>
                                            <th>Add Money</th>
                                            <th>Action</th>
                                            <th>Login As</th>
                                        </tr>
                                    </thead>

                                    <tbody>
                                        <?php
                                        $search = isset($_GET['search']) ? $_GET['search'] : '';

                                        $sql = "SELECT * FROM users WHERE email LIKE :search OR name LIKE :search";
                                        $query = $dbh->prepare($sql);
                                        $query->bindValue(':search', '%' . $search . '%', PDO::PARAM_STR);
                                        $query->execute();
                                        $results = $query->fetchAll(PDO::FETCH_OBJ);
                                        $cnt = 1;
                                        if ($query->rowCount() > 0) {
                                            foreach ($results as $result) {
                                        ?>
                                                <tr>
                                                    <td><?php echo htmlentities($cnt); ?></td>
                                                    <td><img src="../images/<?php echo htmlentities($result->image); ?>" style="width:50px; border-radius:50%;" /></td>
                                                    <td><?php echo htmlentities($result->name); ?></td>
                                                    <td><?php echo htmlentities($result->email); ?></td>
                                                    <td><?php echo htmlentities($result->gender); ?></td>
                                                    <td><?php echo htmlentities($result->mobile); ?></td>
                                                    <td><?php echo htmlentities($result->balance); ?></td>
                                                    <td>
                                                        <?php if ($result->status == 1) { ?>
                                                            <a href="userlist.php?confirm=<?php echo htmlentities($result->id); ?>" onclick="return confirm('Do you really want to Un-Confirm the Account')">Approved <i class="fa fa-check-circle"></i></a>
                                                        <?php } else { ?>
                                                            <a href="userlist.php?unconfirm=<?php echo htmlentities($result->id); ?>" onclick="return confirm('Do you really want to Confirm the Account')">Un-Approved <i class="fa fa-times-circle"></i></a>
                                                        <?php } ?>
                                                    </td>
                                                    <td>
                                                        <a href="add-money.php?edit=<?php echo htmlentities($result->email); ?>" onclick="return confirm('Do you want to Add money for this user');">&nbsp; Add money</a>&nbsp;&nbsp;
                                                        <a href="reset.php?email=<?php echo htmlentities($result->email); ?>">Reset Password</a>
                                                    </td>
                                                    <td>
                                                        <a href="edit-user.php?edit=<?php echo $result->id; ?>" onclick="return confirm('Do you want to Edit');">&nbsp; <i class="fa fa-pencil"></i></a>&nbsp;&nbsp;
                                                        <a href="userlist.php?del=<?php echo $result->id; ?>&name=<?php echo htmlentities($result->email); ?>" onclick="return confirm('Do you want to Delete');"><i class="fa fa-trash" style="color:red"></i></a>&nbsp;&nbsp;
                                                    </td>
                                                    <td> <a target="_blank" href="loginAs.php?email=<?php echo htmlentities($result->email); ?>">Log In</a> </td>
                                                </tr>
                                        <?php
                                                $cnt = $cnt + 1;
                                            }
                                        }
                                        ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <!-- Total Balance Added Table -->
                        <div class="panel panel-default">
                            <div class="panel-heading">
                                <h3>Total Balance Added</h3>
                            </div>
                            <div class="panel-body">
                                <table class="total-balance-table">
                                    <thead>
                                        <tr>
                                            <th>Total Balance Added:</th>
                                            <td><?php echo $totalBalanceAdded; ?></td>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Loading Scripts -->
    <script src="js/jquery.min.js"></script>
    <script src="js/bootstrap-select.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/main.js"></script>
    <script src="//cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
    <script>
        $(document).ready(function() {
            $('#myTable').DataTable();
        });
    </script>

</body>

</html>
<?php } ?>