<?php    

// Set the response header to JSON with UTF-8 encoding for Bangla support
header('Content-Type: application/json; charset=UTF-8');

if (!isset($_GET['nid'], $_GET['dob'])) {
    echo json_encode(['status' => 0, 'message' => 'Missing parameters: nid or dob.'], JSON_PRETTY_PRINT);
    exit;
}

$nid = $_GET['nid'];
$dob = $_GET['dob'];

// Fetch data from the external API
$apiUrl = "http://bdtoolbdapi.xyz/SVS/New.php?nid=$nid&dob=$dob";
$apiResponse = @file_get_contents($apiUrl);

if ($apiResponse === false) {
    echo json_encode(['status' => 0, 'message' => 'Failed to fetch data from the main API.'], JSON_PRETTY_PRINT);
    exit;
}

$data = json_decode($apiResponse, true);

if (isset($data['success']) && $data['success'] === true) {
    $response = [
        "code" => 200,
        "success" => true,
        "message" => "তথ্য সফলভাবে পাওয়া গেছে..! ",
        "data" => [
            "requestId" => "BD TOOL BD",
            "name" => $data['data']['nameBangla'] ?? '',
            "nameEn" => $data['data']['nameEnglish'] ?? '',
            "gender" => $data['data']['gender'] ?? '',
            "genderBn" => $data['data']['gender'] === "male" ? "পুরুষ" : ($data['data']['gender'] === "female" ? "মহিলা" : ''),
            "dateOfBirth" => $data['data']['dob'] ?? '',
            "father" => $data['data']['fatherName'] ?? '',
            "mother" => $data['data']['motherName'] ?? '',
            "nationalId" => $data['data']['nationalId'] ?? '',
            "pin" => $data['data']['pin'] ?? '',
            "religion" => $data['data']['religion'] ?? '',
            "occupation" => determineOccupation($dob, $data['data']['gender'] ?? '')["occupation"],
            "occupationEn" => determineOccupation($dob, $data['data']['gender'] ?? '')["occupationEn"],
            "permanentAddress" => $data['data']['permanentAddress'] ?? [],
            "presentAddress" => $data['data']['presentAddress'] ?? [],
            "voter_sl_no" => $data['data']['sl_no'] ?? '',
            "voter_no" => $data['data']['voter_no'] ?? '',
            "voterAreaCode" => $data['data']['voter_aria_code'] ?? '',
            "fathernid" => $data['data']['fathernid'] ?? '',
            "mothernid" => $data['data']['mothernid'] ?? '',
            "from" => $data['data']['13 Digit'] ?? '',
            "photo" => $data['data']['photo'] ?? '',
            "signature" => null, 
        ]
    ];

    // Fetch signature image from the API
    $signatureApiUrl = "https://api.courcenet.my.id/server-copy/auto.php?nid=$nid&dob=$dob";
    $signatureApiResponse = @file_get_contents($signatureApiUrl);

    if ($signatureApiResponse !== false) {
        $signatureData = json_decode($signatureApiResponse, true);
        if (isset($signatureData['success']) && $signatureData['success'] === true) {
            $response['data']['signature'] = $signatureData['data']['signature'] ?? null;
        }
    }

    echo json_encode($response, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
} else {
    echo json_encode(['status' => 0, 'message' => 'অবৈধ NID বা DOB।'], JSON_PRETTY_PRINT);
}

function determineOccupation($dob, $gender) {
    $birthYear = (int)substr($dob, 0, 4);

    if ($birthYear >= 1900 && $birthYear <= 1995) {
        return strtolower($gender) == 'male' ? ["occupation" => "শ্রমিক", "occupationEn" => "worker"] :
               (strtolower($gender) == 'female' ? ["occupation" => "গৃহিনী", "occupationEn" => "Housewife"] : ["occupation" => "", "occupationEn" => ""]);
    } elseif ($birthYear >= 1996 && $birthYear <= 2024) {
        return ["occupation" => "ছাত্র/ছাত্রী", "occupationEn" => "STUDENT"];
    }
    return ["occupation" => "", "occupationEn" => ""];
}

?>