<?php

header("Content-Type: application/json");

// Function to get data from an external API
function fetchApiData($number) {
    $url = "https://api-store.top/location/btscode.php?msisdn=" . urlencode($number);
    $response = file_get_contents($url);
    return json_decode($response, true);
}

// Load keys and balances from kay.json
$keyFile = 'data/key.json';
$keyData = json_decode(file_get_contents($keyFile), true);

// Check if key and number parameters are provided
if (!isset($_GET['key']) || !isset($_GET['number'])) {
    echo json_encode([
        "code" => 400,
        "success" => "false",
        "message" => "Key and number parameters are required"
    ]);
    exit;
}

$providedKey = $_GET['key'];
$number = $_GET['number'];

// Find the key entry
$foundKey = null;
foreach ($keyData['keys'] as $keyEntry) {
    if ($keyEntry['key'] === $providedKey) {
        $foundKey = $keyEntry;
        break;
    }
}

// Validate key
if ($foundKey === null) {
    echo json_encode([
        "code" => 401,
        "success" => "false",
        "message" => "Invalid API key"
    ]);
    exit;
}

// Check balance
if ($foundKey['balance'] <= 0) {
    echo json_encode([
        "code" => 402,
        "success" => "false",
        "message" => "Insufficient balance"
    ]);
    exit;
}

// Fetch data from external API
$data = fetchApiData($number);

// Check if the external API response was successful
if (!$data || !isset($data['data'])) {
    echo json_encode([
        "code" => 500,
        "success" => "false",
        "message" => "এই নাম্বারের লোকেশান নাই।"
    ]);
    exit;
}

// Reduce balance by 1 and save it back to kay.json
foreach ($keyData['keys'] as &$keyEntry) {
    if ($keyEntry['key'] === $providedKey) {
        $keyEntry['balance'] -= 1; // Reduce the balance
        break;
    }
}
file_put_contents($keyFile, json_encode($keyData)); // Save the updated key data back to file

// Send successful response
echo json_encode([
    "code" => 200,
    "success" => "true",
    "data" => $data['data'],  // Data from the external API
    "DEV BY" => "BD TOOL BD"
]);

?>
