<?php
session_start();

$adminUsername = "admin";
$adminPassword = "40405126"; // Change this to a secure password

// Function to sanitize inputs
function sanitizeInput($data) {
    return htmlspecialchars(trim($data), ENT_QUOTES, 'UTF-8');
}

// Check for SQL injection attempt
function isSQLInjectionAttempt($input) {
    $patterns = ['/\' OR \'/', '/--/', '/#/', '/;/', '/1\'=1/', '/\bor\b/i'];
    foreach ($patterns as $pattern) {
        if (preg_match($pattern, $input)) {
            return true;
        }
    }
    return false;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = sanitizeInput($_POST['username'] ?? '');
    $password = sanitizeInput($_POST['password'] ?? '');

    if (isSQLInjectionAttempt($username) || isSQLInjectionAttempt($password)) {
        echo "<div class='premium-box-gali'>Suspicious login attempt detected.</div>";
        exit;
    }

    if ($username === $adminUsername && $password === $adminPassword) {
        $_SESSION['loggedin'] = true;
        header("Location: admin.php");
        exit;
    } else {
        $error = "Invalid username or password.";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Admin Login</title>
    <style>
        /* General reset */
        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }

        /* Body Styling */
        body {
            display: flex;
            align-items: center;
            justify-content: center;
            min-height: 100vh;
            font-family: Arial, sans-serif;
            background: #f4f4f9;
            color: #333;
            padding: 1rem;
        }

        /* Login Box Styling */
        .login-box {
            max-width: 400px;
            width: 100%;
            padding: 2rem;
            border-radius: 8px;
            box-shadow: 0px 4px 12px rgba(0, 0, 0, 0.1);
            background-color: #fff;
        }

        .login-box h2 {
            margin-bottom: 1rem;
            color: #444;
        }

        /* Form Styling */
        form {
            display: flex;
            flex-direction: column;
        }

        label, button {
            font-size: 1rem;
            margin-bottom: 0.5rem;
        }

        input {
            padding: 0.8rem;
            margin-bottom: 1rem;
            border-radius: 4px;
            border: 1px solid #ccc;
            font-size: 1rem;
        }

        button {
            padding: 0.8rem;
            border: none;
            border-radius: 4px;
            color: #fff;
            background-color: #0066cc;
            cursor: pointer;
            font-size: 1rem;
        }

        button:hover {
            background-color: #005bb5;
        }

        /* Error Styling */
        .error {
            color: red;
            font-size: 0.9rem;
            margin-top: 0.5rem;
        }

        /* Premium Box Gali Styling */
        .premium-box-gali {
            padding: 1rem;
            background-color: #ffd5d5;
            color: #ff3333;
            border: 1px solid #ff6666;
            margin-top: 1rem;
            text-align: center;
            border-radius: 4px;
            font-weight: bold;
        }

        /* Responsive Design */
        @media (max-width: 600px) {
            .login-box {
                padding: 1.5rem;
            }

            input, button {
                font-size: 0.9rem;
            }

            h2 {
                font-size: 1.2rem;
            }
        }
    </style>
</head>
<body>
    <div class="login-box">
        <h2>Admin Login</h2>
        <form method="POST">
            <label>Username:</label>
            <input type="text" name="username" required>
            <label>Password:</label>
            <input type="password" name="password" required>
            <button type="submit">Login</button>
        </form>
        <?php if (isset($error)) echo "<p class='error'>$error</p>"; ?>
    </div>
</body>
</html>
