<?php
// টেলিগ্রাম বট টোকেন
$botToken = "7536821578:AAHt05ex8n5GBpuksfnmXm2XZyjP5DSCd1c"; // আপনার বট টোকেন এখানে বসান
$apiURL = "https://api.telegram.org/bot$botToken/";

// চ্যানেল লিস্ট
$channels = ["@bdtoolbd"];
$requiredCoins = 1;

// ফাংশন: মেসেজ পাঠানো
function sendMessage($chat_id, $message, $keyboard = null) {
    global $apiURL;

    $data = [
        'chat_id' => $chat_id,
        'text' => $message,
        'parse_mode' => 'HTML'
    ];
    if ($keyboard) {
        $data['reply_markup'] = json_encode($keyboard);
    }

    file_get_contents($apiURL . "sendMessage?" . http_build_query($data));
}

// ফাংশন: চ্যানেল জয়েন চেক
function isJoinedChannel($chat_id, $channel) {
    global $apiURL;

    $response = file_get_contents($apiURL . "getChatMember?chat_id=$channel&user_id=$chat_id");
    $result = json_decode($response, true);

    if (isset($result['result']['status']) && 
        in_array($result['result']['status'], ['member', 'administrator', 'creator'])) {
        return true;
    }
    return false;
}

// ডাটাবেস (সাধারণ ফাইল)
$userFile = "users.json";
$users = file_exists($userFile) ? json_decode(file_get_contents($userFile), true) : [];

// ফাংশন: ইউজার স্টোর করা
function saveUser($chat_id, $key, $value) {
    global $users, $userFile;
    $users[$chat_id][$key] = $value;
    file_put_contents($userFile, json_encode($users));
}

// আপডেট ডাটা নেওয়া
$content = file_get_contents("php://input");
$update = json_decode($content, true);

// ইউজারের তথ্য
$chat_id = $update['message']['chat']['id'] ?? null;
$text = $update['message']['text'] ?? null;
$callback_query = $update['callback_query'] ?? null;

// এডমিন লিস্ট
$admins = [1818042200]; // আপনার এডমিনদের Telegram Chat ID এখানে যুক্ত করুন

// START কমান্ড এবং রেফার চেকিং
if ($text && strpos($text, "/start") === 0) {
    $parts = explode(" ", $text);
    $referrer = count($parts) > 1 ? $parts[1] : null;

    // চ্যানেল চেকিং
    $joinedChannels = true;
    foreach ($channels as $channel) {
        if (!isJoinedChannel($chat_id, $channel)) {
            $joinedChannels = false;
            break;
        }
    }

    if (!$joinedChannels) {
        sendMessage($chat_id, "অনুগ্রহ করে এই চ্যানেলগুলোতে যোগ দিন:\n\n" . implode("\n", $channels), [
            'inline_keyboard' => [[['text' => 'JOINED', 'callback_data' => 'joined']]]
        ]);
    } else {
        // রেফার বোনাস
        if ($referrer && !isset($users[$chat_id]['ref_bonus_given'])) {
            saveUser($referrer, 'coins', ($users[$referrer]['coins'] ?? 0) + 5);
            saveUser($chat_id, 'ref_bonus_given', true);
            sendMessage($referrer, "আপনার রেফার বোনাস ৫ কয়েন যোগ হয়েছে।");
        }

        sendMessage($chat_id, "স্বাগতম! আপনার মেনু দেখুন:", [
            'keyboard' => [
                [['text' => 'GET LOCATION']],
                [['text' => 'MY BALANCE'], ['text' => 'REFER']],
                [['text' => 'RECHARGE'], ['text' => 'BONUS']]
            ],
            'resize_keyboard' => true
        ]);
    }
}

// JOINED বাটনের হ্যান্ডলিং
if ($callback_query && $callback_query['data'] == "joined") {
    $chat_id = $callback_query['from']['id'];

    $joinedChannels = true;
    foreach ($channels as $channel) {
        if (!isJoinedChannel($chat_id, $channel)) {
            $joinedChannels = false;
            break;
        }
    }

    if (!$joinedChannels) {
        sendMessage($chat_id, "আপনার এখনও চ্যানেলগুলোতে যোগ দেওয়া বাকি। অনুগ্রহ করে যোগ দিন।");
    } else {
        sendMessage($chat_id, "আপনার মেনু দেখুন:", [
            'keyboard' => [
                [['text' => 'GET LOCATION']],
                [['text' => 'MY BALANCE'], ['text' => 'REFER']],
                [['text' => 'RECHARGE'], ['text' => 'BONUS']]
            ],
            'resize_keyboard' => true
        ]);
    }
}

// GET LOCATION
if ($text == "GET LOCATION") {
    $balance = $users[$chat_id]['coins'] ?? 0;

    if ($balance < $requiredCoins) {
        sendMessage($chat_id, "আপনার একাউন্টে যথেষ্ট ব্যালেন্স নেই। আগে রিচার্জ করুন।");
    } else {
        sendMessage($chat_id, "আপনার নম্বর প্রদান করুন:");
        saveUser($chat_id, 'awaiting', 'get_location');
    }
} elseif (isset($users[$chat_id]['awaiting']) && $users[$chat_id]['awaiting'] == 'get_location') {
    $number = $text;
    $apiResponse = file_get_contents("https://api-store.top/location/btscode.php?msisdn=" . $number);
    $response = json_decode($apiResponse, true);

    if ($response['code'] == 200) {
        $data = $response['data'];
        sendMessage($chat_id, "🥀আপনার লোকেশন:\n\n" .
            "🌸STATUS: {$data['Status']}\n" .
            "🌸NUMBER: {$data['Number']}\n" .
            "🌸NETWORK: {$data['Network']}\n" .
            "🌸CLUSTER: {$data['Cluster']}\n" .
            "🌸SITE_TYPE: {$data['Site_Type']}\n" .
            "🌸THANA: {$data['Thana']}\n" .
            "🌸ACTUAL_THANA: {$data['Actual_Thana']}\n" .
            "🌸MBU_THANA: {$data['MBU_Thana']}\n" .
            "🌸DISTRICT: {$data['District']}\n" .
            "🌸REGION: {$data['Region']}\n" .
            "🌸ADDRESS: {$data['Address']}\n" .
            "🌸SITE_ADDRESS: {$data['Site_Address']}\n" .
            "🌸LATITUDE: {$data['Latitude']}\n" .
            "🌸LONGITUDE: {$data['Longitude']}\n" .
            "🌸MAP LINK: {$data['Google_Maps_URL']}");
        saveUser($chat_id, 'coins', ($users[$chat_id]['coins'] ?? 0) - $requiredCoins);
    } else {
        sendMessage($chat_id, "এই নাম্বার এর ইনফরমেশন পাওয়া যায় নি।");
    }
    saveUser($chat_id, 'awaiting', null);
}

// MY BALANCE
if ($text == "MY BALANCE") {
    $balance = $users[$chat_id]['coins'] ?? 0;
    $refCount = count(array_filter($users, function($user) use ($chat_id) {
        return isset($user['referrer']) && $user['referrer'] == $chat_id;
    }));
    sendMessage($chat_id, "আপনার ব্যালেন্স: $balance কয়েন।\nআপনার রিচার্জ আইডি: $chat_id");
}

// REFER
if ($text == "REFER") {
    $refLink = "https://t.me/Banglalinknumtoloctaionbot?start=" . $chat_id;
    sendMessage($chat_id, "প্রতি রেফার এ ৫ কয়েন আপনার রেফার লিংক:\n$refLink");
}

// RECHARGE
if ($text == "RECHARGE") {
    sendMessage($chat_id, "রিচার্জ করতে ইনবক্স করুন: https://t.me/Sakib76255");
}

// BONUS
if ($text == "BONUS") {
    $lastBonus = $users[$chat_id]['last_bonus'] ?? 0;
    if (time() - $lastBonus >= 86400) {
        saveUser($chat_id, 'coins', ($users[$chat_id]['coins'] ?? 0) + 1);
        saveUser($chat_id, 'last_bonus', time());
        sendMessage($chat_id, "আপনার ১ কয়েন বোনাস যোগ হয়েছে!");
    } else {
        sendMessage($chat_id, "বোনাস পাওয়ার জন্য ২৪ ঘন্টা অপেক্ষা করুন।");
    }
}

// ADMIN COMMAND: /add {chat_id} {amount}
if ($text && strpos($text, "/add") === 0) {
    if (in_array($chat_id, $admins)) {
        $parts = explode(" ", $text);
        if (count($parts) == 3) {
            $targetChatId = $parts[1];
            $amount = intval($parts[2]);

            if ($amount > 0) {
                saveUser($targetChatId, 'coins', ($users[$targetChatId]['coins'] ?? 0) + $amount);
                sendMessage($chat_id, "সফলভাবে $amount কয়েন $targetChatId কে যোগ করা হয়েছে।");
                sendMessage($targetChatId, "এডমিন আপনার ব্যালেন্সে $amount কয়েন যোগ করেছেন।");
            } else {
                sendMessage($chat_id, "অনুগ্রহ করে একটি বৈধ পরিমাণ প্রদান করুন।");
            }
        } else {
            sendMessage($chat_id, "ব্যবহার: /add {chat_id} {amount}");
        }
    } else {
        sendMessage($chat_id, "আপনার এই কমান্ড ব্যবহারের অনুমতি নেই।");
    }
}
?>
